(define/contract (max-power fields)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define events '())
  (for ([field fields])
    (define x1 (first field))
    (define y1 (second field))
    (define x2 (third field))
    (define y2 (fourth field))
    (set! events (cons (list x1 y1 y2 1) events))
    (set! events (cons (list x2 y1 y2 -1) events)))
  (set! events (sort events (lambda (a b) (or (< (first a) (first b)) (and (= (first a) (first b)) (< (third a) (third b)))))))
  (define active '())
  (define max-overlap 0)
  (define current-overlap 0)
  (define prev-x (first (first events)))
  (for ([event events])
    (define x (first event))
    (define y1 (second event))
    (define y2 (third event))
    (define delta (fourth event))
    (when (not (= x prev-x))
      (set! max-overlap (max max-overlap current-overlap))
      (set! prev-x x))
    (if (= delta 1)
        (set! active (sort (cons (cons y1 y2) active) (lambda (a b) (or (< (car a) (car b)) (and (= (car a) (car b)) (< (cdr a) (cdr b)))))))
        (set! active (remove (cons y1 y2) active)))
    (define merged '())
    (define current-start -inf.0)
    (define current-end -inf.0)
    (for ([interval active])
      (define start (car interval))
      (define end (cdr interval))
      (if (> start current-end)
          (begin
            (when (> current-end -inf.0)
              (set! merged (cons (cons current-start current-end) merged)))
            (set! current-start start)
            (set! current-end end))
          (set! current-end (max current-end end))))
    (when (> current-end -inf.0)
      (set! merged (cons (cons current-start current-end) merged)))
    (set! current-overlap (for/sum ([m merged]) (- (cdr m) (car m)))))
  max-overlap)